/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.InstanceCollectionVector;
import org.nakedobjects.nof.core.persist.OidGenerator;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;

public abstract class AbstractObjectPersistor
implements NakedObjectPersistor,
DebugInfo {
    private OidGenerator oidGenerator;

    public abstract void abortTransaction();

    public Oid createTransientOid(Object object) {
        return this.oidGenerator.createTransientOid(object);
    }

    public void convertPersistentToTransientOid(Oid oid) {
        this.oidGenerator.convertPersistentToTransientOid(oid);
    }

    public void convertTransientToPersistentOid(Oid oid) {
        this.oidGenerator.convertTransientToPersistentOid(oid);
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("OID Generator");
        this.oidGenerator.debugData(debug);
        debug.appendln();
    }

    public NakedCollection findInstances(InstancesCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException();
        }
        NakedObject[] instances = this.getInstances(criteria);
        NakedObjectSpecification specification = criteria.getSpecification();
        InstanceCollectionVector collection = new InstanceCollectionVector(specification, instances);
        return collection;
    }

    protected abstract NakedObject[] getInstances(InstancesCriteria var1);

    public void init() {
        Assert.assertNotNull("OID generator required", this.oidGenerator);
        this.oidGenerator.init();
    }

    public void set_OidGenerator(OidGenerator oidGenerator) {
        this.oidGenerator = oidGenerator;
    }

    public void setOidGenerator(OidGenerator oidGenerator) {
        this.oidGenerator = oidGenerator;
    }

    public void shutdown() {
        this.oidGenerator.shutdown();
        this.oidGenerator = null;
    }
}

