/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.persist.UnsupportedFindException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.Logger;

public class ObjectPersistorLogger
extends Logger
implements NakedObjectPersistor,
DebugInfo {
    private final NakedObjectPersistor decorated;

    public ObjectPersistorLogger(NakedObjectPersistor decorated, String logFileName) {
        super(logFileName, false);
        this.decorated = decorated;
    }

    public ObjectPersistorLogger(NakedObjectPersistor decorated) {
        super(null, false);
        this.decorated = decorated;
    }

    public void abortTransaction() {
        this.log("abort transaction");
        this.decorated.abortTransaction();
    }

    public Oid createTransientOid(Object object) {
        Oid oid = this.decorated.createTransientOid(object);
        this.log("create oid ", oid);
        return oid;
    }

    public void convertPersistentToTransientOid(Oid oid) {
        this.decorated.convertPersistentToTransientOid(oid);
        this.log("convert persistent to transient Oid", oid);
    }

    public void convertTransientToPersistentOid(Oid oid) {
        this.decorated.convertTransientToPersistentOid(oid);
        this.log("convert transient to persistent Oid", oid);
    }

    public void destroyObject(NakedObject object) {
        this.log("destroy " + object.getObject());
        this.decorated.destroyObject(object);
    }

    public void endTransaction() {
        this.log("end transaction");
        this.decorated.endTransaction();
    }

    public NakedCollection findInstances(InstancesCriteria criteria) throws UnsupportedFindException {
        this.log("find instances matching " + criteria);
        return this.decorated.findInstances(criteria);
    }

    public void debugData(DebugString debug) {
        if (this.decorated instanceof DebugInfo) {
            ((DebugInfo)this.decorated).debugData(debug);
        }
    }

    public String debugTitle() {
        if (this.decorated instanceof DebugInfo) {
            return ((DebugInfo)this.decorated).debugTitle();
        }
        return "";
    }

    protected Class getDecoratedClass() {
        return this.decorated.getClass();
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException {
        NakedObject object = this.decorated.getObject(oid, hint);
        this.log("get object for " + oid + " (of type " + hint.getShortName() + ")", object.getObject());
        return object;
    }

    public Oid getOidForService(String name) {
        Oid oid = this.decorated.getOidForService(name);
        this.log("get oid for " + name + ": " + oid);
        return oid;
    }

    public boolean hasInstances(NakedObjectSpecification specification, boolean includeSubclasses) {
        boolean hasInstances = this.decorated.hasInstances(specification, false);
        this.log("has instances of " + specification.getShortName(), "" + hasInstances);
        return hasInstances;
    }

    public boolean isInitialized() {
        boolean isInitialized = this.decorated.isInitialized();
        this.log("is initialized: " + isInitialized);
        return isInitialized;
    }

    public void init() {
        this.log("initialising " + this.decorated);
        this.decorated.init();
    }

    public void makePersistent(NakedObject object) {
        this.log("make object graph persistent: " + object);
        this.decorated.makePersistent(object);
    }

    public void objectChanged(NakedObject object) {
        this.log("object changed " + object);
        this.decorated.objectChanged(object);
    }

    public void setServices(Object[] services) {
        this.decorated.setServices(services);
        StringBuffer servicesList = new StringBuffer();
        for (int i = 0; i < services.length; ++i) {
            if (i > 0) {
                servicesList.append(',');
            }
            servicesList.append(services[i].getClass().getName());
        }
        this.log("registered services {" + servicesList + "}");
    }

    public void reload(NakedObject object) {
        this.decorated.reload(object);
        this.log("reload: " + object);
    }

    public void reset() {
        this.log("reset object manager");
        this.decorated.reset();
    }

    public void resolveImmediately(NakedObject object) {
        this.decorated.resolveImmediately(object);
        this.log("Resolve immediately: " + object);
    }

    public void resolveField(NakedObject object, NakedObjectField field) {
        this.log("resolve eagerly object in field " + field + " of " + object);
        this.decorated.resolveField(object, field);
    }

    public void saveChanges() {
        this.log("saving changes");
        this.decorated.saveChanges();
    }

    public void shutdown() {
        this.log("shutting down " + this.decorated);
        this.decorated.shutdown();
        this.close();
    }

    public void startTransaction() {
        this.log("start transaction");
        this.decorated.startTransaction();
    }

    public boolean flushTransaction() {
        this.log("flush transaction");
        return this.decorated.flushTransaction();
    }
}

