/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.AbstractInstancesCriteria;

public class PatternCriteria
extends AbstractInstancesCriteria {
    private final NakedObject pattern;

    public NakedObject getPattern() {
        return this.pattern;
    }

    public PatternCriteria(boolean includeSubclasses, Object pattern) {
        this(NakedObjectsContext.getReflector().loadSpecification(pattern.getClass()), includeSubclasses, pattern);
    }

    public PatternCriteria(NakedObjectSpecification specification, boolean includeSubclasses, Object pattern) {
        this(specification, includeSubclasses, NakedObjectsContext.getObjectLoader().getAdapterForElseCreateAdapterForTransient(pattern));
    }

    public PatternCriteria(NakedObjectSpecification specification, boolean includeSubclasses, NakedObject pattern) {
        super(specification, includeSubclasses);
        this.pattern = pattern;
    }

    public boolean matches(NakedObject object) {
        NakedObjectSpecification requiredType = this.pattern.getSpecification();
        return requiredType.equals(object.getSpecification()) && this.matchesPattern(this.pattern, object);
    }

    private boolean matchesPattern(NakedObject pattern, NakedObject instance) {
        NakedObject object = instance;
        NakedObjectSpecification nc = object.getSpecification();
        NakedObjectField[] fields = nc.getFields();
        for (int f = 0; f < fields.length; ++f) {
            NakedValue search;
            NakedValue reqd;
            NakedObjectField fld = fields[f];
            if (!fld.isPersisted()) continue;
            if (fld.isValue()) {
                reqd = (NakedValue)fld.get(pattern);
                search = (NakedValue)fld.get(object);
                if (fld.isEmpty(pattern)) continue;
                String r = reqd.titleString().toLowerCase();
                String s = search.titleString().toLowerCase();
                if (s.indexOf(r) != -1) continue;
                return false;
            }
            if (!fld.isObject()) continue;
            reqd = (NakedObject)fld.get(pattern);
            search = (NakedObject)fld.get(object);
            if (reqd == null) continue;
            if (search == null) {
                return false;
            }
            if (reqd == search) continue;
            return false;
        }
        return true;
    }
}

