/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.persist;

import java.io.Serializable;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.util.ByteDecoder;
import org.nakedobjects.noa.util.ByteEncoder;
import org.nakedobjects.noa.util.Encodable;
import org.nakedobjects.nof.core.util.Assert;

public final class SerialOid
implements Oid,
Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean PERSISTENT = false;
    private static final boolean TRANSIENT = true;
    private int hashCode;
    private boolean isTransient;
    private SerialOid previous;
    private long serialNo;
    private String toString;

    public static SerialOid createPersistent(long serialNo) {
        return new SerialOid(serialNo, false);
    }

    public static SerialOid createTransient(long serialNo) {
        return new SerialOid(serialNo, true);
    }

    private SerialOid(long serialNo, boolean isTransient) {
        this.serialNo = serialNo;
        this.isTransient = isTransient;
        this.cacheState();
    }

    public SerialOid(ByteDecoder decoder) {
        this.serialNo = decoder.getLong();
        this.isTransient = decoder.getBoolean();
        boolean hasPrevious = decoder.getBoolean();
        if (hasPrevious) {
            long previousSerialNo = decoder.getLong();
            boolean previousIsTransient = decoder.getBoolean();
            this.previous = new SerialOid(previousSerialNo, previousIsTransient);
        }
        this.cacheState();
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(this.serialNo);
        encoder.add(this.isTransient);
        encoder.add(this.previous != null);
        if (this.previous != null) {
            encoder.add(this.previous.serialNo);
            encoder.add(this.previous.isTransient);
        }
    }

    private void cacheState() {
        this.hashCode = 17;
        this.hashCode = 37 * this.hashCode + (int)(this.serialNo ^ this.serialNo >>> 32);
        this.hashCode = 37 * this.hashCode + (this.isTransient ? 0 : 1);
        this.toString = (this.isTransient ? "T" : "") + "OID#" + Long.toHexString(this.serialNo).toUpperCase() + (this.previous == null ? "" : "+");
    }

    public void copyFrom(Oid oid) {
        Assert.assertTrue(oid instanceof SerialOid);
        SerialOid from = (SerialOid)oid;
        this.serialNo = from.serialNo;
        this.isTransient = from.isTransient;
        this.cacheState();
    }

    void makePersistent(long serialNo) {
        Assert.assertTrue(this.isTransient);
        this.previous = new SerialOid(this.serialNo, this.isTransient);
        this.serialNo = serialNo;
        this.isTransient = false;
        this.cacheState();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SerialOid) {
            SerialOid otherOid = (SerialOid)obj;
            return otherOid.serialNo == this.serialNo && otherOid.isTransient == this.isTransient;
        }
        return false;
    }

    public boolean equals(SerialOid otherOid) {
        if (otherOid == this) {
            return true;
        }
        return otherOid.serialNo == this.serialNo && otherOid.isTransient == this.isTransient;
    }

    public Oid getPrevious() {
        return this.previous;
    }

    public long getSerialNo() {
        return this.serialNo;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String toString() {
        return this.toString;
    }
}

