/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.nof.core.persist.OidGenerator;
import org.nakedobjects.nof.core.persist.SerialOid;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.UnexpectedCallException;

public class SimpleOidGenerator
implements OidGenerator {
    private long persistentSerialNumber;
    private long transientSerialNumber;
    private final long start;

    public SimpleOidGenerator() {
        this(0L);
    }

    public SimpleOidGenerator(long start) {
        this.start = start;
        this.persistentSerialNumber = start;
        this.transientSerialNumber = -start;
    }

    public void debugData(DebugString debug) {
        debug.appendln("Start", this.start);
        debug.appendln("Persistent", this.persistentSerialNumber);
        debug.appendln("Transient", this.transientSerialNumber);
    }

    public String debugTitle() {
        return this.name();
    }

    public void init() {
    }

    public String name() {
        return "Simple Serial OID Generator";
    }

    public void shutdown() {
    }

    public void convertPersistentToTransientOid(Oid oid) {
        throw new UnexpectedCallException();
    }

    public synchronized void convertTransientToPersistentOid(Oid oid) {
        Assert.assertTrue(oid instanceof SerialOid);
        SerialOid serialOid = (SerialOid)oid;
        serialOid.makePersistent(this.persistentSerialNumber++);
    }

    public synchronized Oid createTransientOid(Object object) {
        return SerialOid.createTransient(this.transientSerialNumber++);
    }
}

