/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.persist.AbstractInstancesCriteria;
import org.nakedobjects.nof.core.util.ToString;

public class TitleCriteria
extends AbstractInstancesCriteria {
    private final String requiredTitle;

    public TitleCriteria(NakedObjectSpecification specification, String title, boolean includeSubclasses) {
        super(specification, includeSubclasses);
        this.requiredTitle = title == null ? "" : title.toLowerCase();
    }

    public String getRequiredTitle() {
        return this.requiredTitle;
    }

    public boolean matches(NakedObject object) {
        String titleString = object.titleString();
        return this.matches(titleString);
    }

    public boolean matches(String titleString) {
        String objectTitle = titleString.toLowerCase();
        return objectTitle.indexOf(this.requiredTitle) >= 0;
    }

    public String toString() {
        ToString str = ToString.createAnonymous(this);
        str.append("spec", this.getSpecification().getShortName());
        str.append("subclasses", this.includeSubclasses());
        str.append("title", this.requiredTitle);
        return str.toString();
    }
}

