/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.reflect;

import java.io.Serializable;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;

public abstract class AbstractConsent
implements Serializable,
Consent {
    private final String reason;
    private final RuntimeException exception;

    public static final Consent allow(boolean allow) {
        if (allow) {
            return Allow.DEFAULT;
        }
        return Veto.DEFAULT;
    }

    public static final Consent create(boolean allow, String reasonAllowed, String reasonVeteod) {
        if (allow) {
            return new Allow(reasonAllowed);
        }
        return new Veto(reasonVeteod);
    }

    protected AbstractConsent() {
        this.exception = null;
        this.reason = null;
    }

    protected AbstractConsent(String reason) {
        this.exception = null;
        this.reason = reason;
    }

    protected AbstractConsent(RuntimeException exception) {
        this.exception = exception;
        this.reason = exception != null ? exception.getMessage() : null;
    }

    public String getReason() {
        return this.reason == null ? "" : this.reason;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public abstract boolean isAllowed();

    public abstract boolean isVetoed();

    public String toString() {
        return "Permission [type=" + (this.isVetoed() ? "VETOED" : "ALLOWED") + ", reason=" + this.reason + "]";
    }
}

