/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.security.AuthenticationRequest;
import org.nakedobjects.noa.security.Authenticator;
import org.nakedobjects.nof.core.security.PasswordAuthenticationRequest;
import org.nakedobjects.nof.core.util.Assert;

public class PasswordFileAuthenticator
implements Authenticator {
    private static final boolean FAILED_AUTHENTICATION = false;
    private static final boolean AUTHENTICATED = true;
    private final File passwordFile;

    public PasswordFileAuthenticator(File file) {
        this.passwordFile = file;
    }

    private final void setRoles(String line, AuthenticationRequest request) {
        StringTokenizer tokens = new StringTokenizer(line, "|", false);
        String[] roles = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            roles[i] = tokens.nextToken();
            ++i;
        }
        request.setRoles(roles);
    }

    public final boolean isValid(AuthenticationRequest request) {
        PasswordAuthenticationRequest passwordRequest = (PasswordAuthenticationRequest)request;
        String username = passwordRequest.getName();
        if (username == null || username.equals("")) {
            return false;
        }
        String password = passwordRequest.getPassword();
        Assert.assertNotNull(password);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.passwordFile)));
            while (true) {
                String line;
                if ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().length() == 0) continue;
                    int posFirstColon = line.indexOf(58);
                    if (posFirstColon == -1) {
                        throw new NakedObjectRuntimeException("Invalid entry in password file - no colon (:) found on line: " + line);
                    }
                    String name = line.substring(0, posFirstColon);
                    if (!name.equals(username)) continue;
                    int posSecondColon = line.indexOf(58, posFirstColon + 1);
                    String expected = line.substring(posFirstColon + 1, posSecondColon == -1 ? line.length() : posSecondColon);
                    if (this.checkPassword(expected, password)) {
                        if (posSecondColon != -1) {
                            this.setRoles(line.substring(posSecondColon + 1), request);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new NakedObjectRuntimeException("Failed to open or read password file: " + this.passwordFile.getAbsolutePath());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return false;
    }

    protected boolean checkPassword(String expected, String password) {
        return expected.equals(password);
    }

    public final boolean canAuthenticate(AuthenticationRequest request) {
        return request instanceof PasswordAuthenticationRequest;
    }
}

