/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.security;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.security.AuthenticationRequest;
import org.nakedobjects.noa.security.Authenticator;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.noa.security.SessionManager;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.security.ExplorationSession;
import org.nakedobjects.nof.core.security.NoAuthenticatorException;
import org.nakedobjects.nof.core.security.SimpleSession;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;

public class StandardAuthenticationManager
implements SessionManager,
DebugInfo {
    private static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private final Vector authenticators = new Vector();
    private final Map users = new HashMap();
    private boolean createExploration;

    public final void addAuthenticator(Authenticator authenticator) {
        this.authenticators.addElement(authenticator);
    }

    public final Session authenticate(AuthenticationRequest request) {
        if (this.createExploration) {
            ExplorationSession session = new ExplorationSession();
            return session;
        }
        Enumeration e = this.authenticators.elements();
        while (e.hasMoreElements()) {
            Authenticator authenticator = (Authenticator)e.nextElement();
            if (!authenticator.canAuthenticate(request)) continue;
            SimpleSession user = null;
            if (authenticator.isValid(request)) {
                while (this.users.containsKey((user = this.createSession(request)).getValidationCode())) {
                }
                this.users.put(user.getValidationCode(), user.getUserName());
            }
            return user;
        }
        throw new NoAuthenticatorException("No authenticator available for processing " + request.getClass().getName());
    }

    protected SimpleSession createSession(AuthenticationRequest request) {
        StringBuffer code = new StringBuffer(10);
        for (int i = 0; i < 10; ++i) {
            int pos = (int)(Math.random() * (double)LETTERS.length());
            code.append(LETTERS.charAt(pos));
        }
        return new SimpleSession(request.getName(), request.getRoles(), code.toString());
    }

    public String debugTitle() {
        return "Authentication Manager";
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("Authenticators");
        debug.indent();
        Enumeration e = this.authenticators.elements();
        while (e.hasMoreElements()) {
            debug.appendln(e.nextElement().toString());
        }
        debug.unindent();
        debug.appendTitle("Users");
        debug.indent();
        Iterator i = this.users.values().iterator();
        while (i.hasNext()) {
            debug.appendln(i.next().toString());
        }
        debug.unindent();
    }

    public final boolean isSessionValid(Session session) {
        Object userName = this.users.get(session.getValidationCode());
        if (userName == null) {
            return false;
        }
        return userName.equals(session.getUserName());
    }

    public final void closeSession(Session session) {
        this.users.remove(session.getValidationCode());
        NakedObjectsContext.closeSession();
    }

    public final void init() {
        if (this.authenticators.size() == 0) {
            throw new NakedObjectRuntimeException("No authenticators specified");
        }
    }

    public void setCreateExploration(boolean createExploration) {
        this.createExploration = createExploration;
    }

    public String toString() {
        ToString str = ToString.createAnonymous(this);
        str.append("authenticators", this.authenticators.size());
        str.append("users", this.users.size());
        return str.toString();
    }
}

