/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.service;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.nakedobjects.applib.Filter;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.AllInstances;
import org.nakedobjects.nof.core.persist.TitleCriteria;

public class RepositoryHelper {
    public static Object[] allInstances(Class cls, boolean includeSubclasses) {
        return RepositoryHelper.allInstances(NakedObjectsContext.getReflector().loadSpecification(cls), cls, includeSubclasses);
    }

    public static Object[] allInstances(NakedObjectSpecification spec, Class cls, boolean includeSubclasses) {
        NakedCollection instances = NakedObjectsContext.getObjectPersistor().findInstances((InstancesCriteria)new AllInstances(spec, includeSubclasses));
        Object[] array = RepositoryHelper.convertToArray(instances, cls);
        return array;
    }

    private static List convertToList(NakedCollection instances, Class cls) {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration e = instances.elements();
        while (e.hasMoreElements()) {
            list.add(((NakedObject)e.nextElement()).getObject());
        }
        return list;
    }

    private static Object[] convertToArray(NakedCollection instances, Class cls) {
        return RepositoryHelper.convertToList(instances, cls).toArray();
    }

    public static List filteredInstances(Filter filter, Class cls, boolean includeSubclasses) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        Object[] allInstances = RepositoryHelper.allInstances(cls, includeSubclasses);
        for (int i = 0; i < allInstances.length; ++i) {
            Object instance = allInstances[i];
            if (!filter.accept(instance)) continue;
            filtered.add(instance);
        }
        return filtered;
    }

    public static List findByCriteria(InstancesCriteria criteria, Class cls) {
        NakedCollection instances = NakedObjectsContext.getObjectPersistor().findInstances(criteria);
        return RepositoryHelper.convertToList(instances, cls);
    }

    public static List findByTitle(Class cls, boolean includeSubclasses, String title) {
        return RepositoryHelper.findByTitle(NakedObjectsContext.getReflector().loadSpecification(cls), cls, includeSubclasses, title);
    }

    public static List findByTitle(NakedObjectSpecification spec, Class cls, boolean includeSubclasses, String title) {
        TitleCriteria criteria = new TitleCriteria(spec, title, includeSubclasses);
        return RepositoryHelper.findByCriteria(criteria, cls);
    }

    public static Object firstFilteredInstance(Filter filter, Class cls, boolean includeSubclasses) {
        List filteredInstances = RepositoryHelper.filteredInstances(filter, cls, includeSubclasses);
        return filteredInstances.size() > 0 ? filteredInstances.get(0) : null;
    }

    public static boolean hasInstances(Class cls, boolean includeSubclasses) {
        return RepositoryHelper.hasInstances(NakedObjectsContext.getReflector().loadSpecification(cls), includeSubclasses);
    }

    public static boolean hasInstances(NakedObjectSpecification spec, boolean includeSubclasses) {
        return NakedObjectsContext.getObjectPersistor().hasInstances(spec, includeSubclasses);
    }
}

