/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.service;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.service.SimpleRepository;
import org.nakedobjects.nof.core.system.InitialisationException;
import org.nakedobjects.nof.core.system.InstanceFactory;
import org.nakedobjects.nof.core.system.ServicesInstaller;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;

public class ServicesFromConfiguration
implements ServicesInstaller {
    private static final char DELIMITER = '#';
    private static final Logger LOG = Logger.getLogger(ServicesFromConfiguration.class);
    private static final String SERVICES = "services";
    private static final String SERVICES_PREFIX = "services.prefix";

    public Object[] getServices(boolean forServer) {
        LOG.info((Object)("installing " + this.getClass().getName()));
        Object[] common = this.installServices(NakedObjectsContext.getConfiguration(), null);
        Object[] specific = this.installServices(NakedObjectsContext.getConfiguration(), forServer ? "server" : "client");
        Object[] combined = new Object[common.length + specific.length];
        System.arraycopy(common, 0, combined, 0, common.length);
        System.arraycopy(specific, 0, combined, common.length, specific.length);
        if (combined.length == 0) {
            throw new InitialisationException("No services specified");
        }
        return combined;
    }

    public String getName() {
        return "services-properties";
    }

    private Object installService(String className) {
        return InstanceFactory.createInstance(className);
    }

    private Object[] installServices(NakedObjectConfiguration configuration, String group) {
        String root = "nakedobjects." + (group == null ? "" : group + ".");
        String servicePrefix = configuration.getString(root + SERVICES_PREFIX);
        if (group != null && servicePrefix == null) {
            servicePrefix = configuration.getString("nakedobjects.services.prefix");
        }
        String prefix = this.servicePrefix(servicePrefix);
        String serviceList = configuration.getString(root + SERVICES);
        if (serviceList != null) {
            return this.installServices(prefix, serviceList);
        }
        return new Object[0];
    }

    private Object[] installServices(String servicePrefix, String serviceList) {
        StringTokenizer services = new StringTokenizer(serviceList, ",");
        if (!services.hasMoreTokens()) {
            throw new InitialisationException("Services specified, but none loaded");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (services.hasMoreTokens()) {
            String serviceName = services.nextToken().trim();
            if (serviceName.equals("")) continue;
            LOG.info((Object)("  creating service " + serviceName));
            Object service = serviceName.indexOf(35) == -1 ? this.installService(servicePrefix + serviceName) : this.installSimpleService(servicePrefix, serviceName);
            list.add(service);
        }
        Object[] array = list.toArray(new Object[list.size()]);
        return array;
    }

    private Object installSimpleService(String prefix, String name) {
        int pos = name.indexOf(35);
        String className = prefix + name.substring(pos + 1);
        Class cls = this.loadClass(className);
        String type = name.substring(0, pos);
        if ("repository".equals(type)) {
            return new SimpleRepository(cls);
        }
        throw new InitialisationException("Unknown service type " + type);
    }

    private Class loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException("Cannot find service class " + className);
        }
    }

    private String servicePrefix(String servicePrefix) {
        String prefix;
        String string = prefix = servicePrefix == null ? "" : servicePrefix.trim();
        if (prefix.length() > 0 && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return prefix;
    }
}

