/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.service;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.service.RepositoryHelper;
import org.nakedobjects.nof.core.util.ToString;

public final class SimpleRepository {
    private final Class cls;
    private NakedObjectSpecification spec;
    private boolean includeSubclasses;

    public static String[] parameterNamesFindByTitle() {
        return new String[]{"Title to find"};
    }

    public static boolean[] parametersRequiredFindByTitle() {
        return new boolean[]{true};
    }

    public SimpleRepository(Class cls) {
        this.cls = cls;
    }

    public Object[] allInstances() {
        return RepositoryHelper.allInstances(this.getSpec(), this.cls, this.includeSubclasses);
    }

    public String disableAllInstances() {
        return this.hasInstances() ? null : "No " + this.getSpec().getPluralName();
    }

    public String disableFindByTitle() {
        return this.disableAllInstances();
    }

    public Object[] findByTitle(String title) {
        return RepositoryHelper.findByTitle(this.getSpec(), this.cls, this.includeSubclasses, title).toArray();
    }

    public String getId() {
        return "repository#" + this.getClass().getName();
    }

    private boolean hasInstances() {
        return RepositoryHelper.hasInstances(this.getSpec(), this.includeSubclasses);
    }

    public String iconName() {
        return this.getSpec().getShortName();
    }

    public Object newPersistentInstance() {
        NakedObject adapter = NakedObjectsContext.getObjectLoader().createTransientInstance(this.getSpec());
        NakedObjectsContext.getObjectPersistor().makePersistent(adapter);
        return adapter.getObject();
    }

    public Object newTransientInstance() {
        return NakedObjectsContext.getObjectLoader().createTransientInstance(this.getSpec()).getObject();
    }

    public String title() {
        return this.getSpec().getPluralName();
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("class", this.cls.getName());
        return str.toString();
    }

    public static boolean alwaysHideSpec() {
        return true;
    }

    protected NakedObjectSpecification getSpec() {
        if (this.spec == null) {
            this.spec = NakedObjectsContext.getReflector().loadSpecification(this.cls);
            this.includeSubclasses = Features.isAbstract((NakedObjectSpecification)this.spec);
        }
        return this.spec;
    }
}

