/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.undo;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.nof.core.undo.Command;

public class AssociateCommand
implements Command {
    private final String description;
    private final OneToOneAssociation field;
    private final NakedObject object;
    private final NakedObject associatedObject;
    private String name;

    public AssociateCommand(NakedObject object, NakedObject associatedObject, OneToOneAssociation field) {
        this.description = "Clear association of " + associatedObject.titleString();
        this.name = "associate " + associatedObject.titleString();
        this.object = object;
        this.associatedObject = associatedObject;
        this.field = field;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void undo() {
        this.field.clearAssociation(this.object, this.associatedObject);
    }

    public void execute() {
        this.field.setAssociation(this.object, this.associatedObject);
    }
}

