/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.undo;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.undo.Command;

public class SetValueCommand
implements Command {
    private final String description;
    private final OneToOneAssociation value;
    private NakedObject object;
    private String oldValue;

    public SetValueCommand(NakedObject object, OneToOneAssociation value) {
        NakedValue fld = (NakedValue)value.get(object);
        this.oldValue = fld.asEncodedString();
        this.object = object;
        this.value = value;
        this.description = "reset the value to " + this.oldValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void undo() {
        NakedValue fld = (NakedValue)this.value.get(this.object);
        fld.restoreFromEncodedString(this.oldValue);
        NakedObjectsContext.getObjectPersistor().saveChanges();
    }

    public void execute() {
    }

    public String getName() {
        return "entry";
    }
}

