/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.util;

import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;

public class DebugOutput {
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    private static final Font TEXT_FONT = new Font("SansSerif", 0, 10);
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 12);

    public static void print(String title, String text) {
        Frame parent = new Frame();
        PrintJob job = Toolkit.getDefaultToolkit().getPrintJob(parent, "Print " + title, null);
        if (job != null) {
            Graphics graphic = job.getGraphics();
            if (graphic != null) {
                graphic.translate(10, 10);
                int x = 50;
                int y = 50;
                graphic.setFont(TITLE_FONT);
                int height = graphic.getFontMetrics().getAscent();
                int width = graphic.getFontMetrics().stringWidth(title);
                graphic.drawRect(x - 10, y - 10 - height, width + 20, height + 20);
                graphic.drawString(title, x, y);
                y += graphic.getFontMetrics().getHeight();
                y += 20;
                graphic.setFont(TEXT_FONT);
                StringTokenizer tk = new StringTokenizer(text, "\n\r");
                while (tk.hasMoreTokens()) {
                    String line = tk.nextToken();
                    graphic.drawString(line, x, y);
                    y += graphic.getFontMetrics().getHeight();
                }
                graphic.dispose();
            }
            job.end();
        }
        parent.dispose();
    }

    public static void saveToClipboard(String text) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(text);
        cb.setContents(ss, ss);
    }

    public static void saveToFile(DebugInfo object) {
        String dateStamp = FORMAT.format(new Date());
        String fileName = object.getClass().getName() + "-" + dateStamp + ".txt";
        DebugString text = new DebugString();
        object.debugData(text);
        String title = object.debugTitle();
        DebugOutput.saveToFile(new File(fileName), title, text.toString());
    }

    public static void saveToFile(File file, String title, String text) {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            writer.println(title);
            writer.println();
            writer.println(text.toString());
            writer.close();
        }
        catch (IOException e) {
            throw new NakedObjectRuntimeException((Throwable)e);
        }
    }

    public static void saveToFile(String saveDialogTitle, String title, String text) {
        Frame parent = new Frame();
        FileDialog dialog = new FileDialog(parent, saveDialogTitle, 1);
        dialog.show();
        String file = dialog.getFile();
        String dir = dialog.getDirectory();
        parent.dispose();
        DebugOutput.saveToFile(new File(dir, file), title, text);
    }
}

