/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.util;

import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedCollectionSpecification;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.Debug;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;

public class Dump {
    private static void collectionGraph(NakedCollection collection, int level, Vector ignoreObjects, DebugString s) {
        if (ignoreObjects.contains(collection)) {
            s.append("*\n");
        } else {
            ignoreObjects.addElement(collection);
            Enumeration e = collection.elements();
            while (e.hasMoreElements()) {
                Dump.graphIndent(s, level);
                NakedObject element = (NakedObject)e.nextElement();
                s.append(element);
                if (ignoreObjects.contains(element)) {
                    s.append("*\n");
                    continue;
                }
                s.indent();
                Dump.graph((Naked)element, level + 1, ignoreObjects, s);
                s.unindent();
            }
        }
    }

    public static String graph(Naked object) {
        DebugString s = new DebugString();
        Dump.graph(object, s);
        return s.toString();
    }

    public static void graph(Naked object, DebugString s) {
        Dump.simpleObject(object, s);
        s.appendln();
        s.append(object);
        Dump.graph(object, 0, new Vector(25, 10), s);
    }

    private static void simpleObject(Naked object, DebugString s) {
        s.appendln(object.titleString());
        s.indent();
        if (object instanceof NakedCollection) {
            Enumeration e = ((NakedCollection)object).elements();
            int i = 1;
            while (e.hasMoreElements()) {
                NakedObject element = (NakedObject)e.nextElement();
                s.appendln(i++ + " " + element.titleString());
            }
        } else if (object instanceof NakedObject) {
            try {
                NakedObjectField[] fields = object.getSpecification().getFields();
                for (int i = 0; i < fields.length; ++i) {
                    NakedObjectField field = fields[i];
                    Naked obj = field.get((NakedObject)object);
                    String name = field.getId();
                    if (obj == null) {
                        s.appendln(name, "null");
                        continue;
                    }
                    s.appendln(name, obj.titleString());
                }
            }
            catch (RuntimeException e) {
                s.appendException(e);
            }
        }
        s.unindent();
    }

    private static void graph(Naked object, int level, Vector ignoreObjects, DebugString info) {
        if (level > 3) {
            info.appendln("...");
        } else {
            info.append("\n");
            if (object instanceof NakedCollection) {
                Dump.collectionGraph((NakedCollection)object, level, ignoreObjects, info);
            } else if (object instanceof NakedObject) {
                Dump.objectGraph((NakedObject)object, level, ignoreObjects, info);
            } else {
                info.append("??? " + object);
            }
        }
    }

    public static String graph(Naked object, Vector excludedObjects) {
        DebugString s = new DebugString();
        s.append(object);
        Dump.graph(object, 0, excludedObjects, s);
        return s.toString();
    }

    private static void graphIndent(DebugString s, int level) {
        for (int indent = 0; indent < level; ++indent) {
            s.append(Debug.indentString(4) + "|");
        }
        s.append(Debug.indentString(4) + "+--");
    }

    public static String adapter(Naked object) {
        DebugString s = new DebugString();
        Dump.adapter(object, s);
        return s.toString();
    }

    public static void adapter(Naked object, DebugString string) {
        try {
            string.appendln("Adapter", object.getClass().getName());
            string.appendln("Class", object.getObject() == null ? "none" : object.getObject().getClass().getName());
            string.appendAsHexln("Hash", object.hashCode());
            string.appendln("Object", object.getObject());
            string.appendln("Title", object.titleString());
            string.appendln("Specification", object.getSpecification().getFullName());
            string.appendln();
            if (object instanceof NakedObject) {
                NakedObject nakedObject = (NakedObject)object;
                string.appendln("Icon", nakedObject.getIconName());
                string.appendln("OID", nakedObject.getOid());
                string.appendln("Persistable", nakedObject.persistable());
                string.appendln("State", nakedObject.getResolveState());
                string.appendln("Version", nakedObject.getVersion());
            }
        }
        catch (RuntimeException e) {
            string.appendException(e);
        }
    }

    private static void objectGraph(NakedObject object, int level, Vector ignoreObjects, DebugString s) {
        ignoreObjects.addElement(object);
        try {
            NakedObjectField[] fields = object.getSpecification().getFields();
            for (int i = 0; i < fields.length; ++i) {
                NakedObjectField field = fields[i];
                Naked obj = field.get(object);
                String name = field.getId();
                Dump.graphIndent(s, level);
                if (!field.isVisible()) {
                    s.append(name + ": (not visible)");
                    s.append("\n");
                    continue;
                }
                if (!field.isVisibleDeclaratively()) {
                    s.append(name + ": (not visible declaratively)");
                    s.append("\n");
                    continue;
                }
                if (!field.isVisible((NakedReference)object)) {
                    s.append(name + ": (not visible based on state of object)");
                    s.append("\n");
                    continue;
                }
                if (!field.isVisibleForSession()) {
                    s.append(name + ": (not visible for session)");
                    s.append("\n");
                    continue;
                }
                if (obj == null) {
                    s.append(name + ": null\n");
                    continue;
                }
                if (obj.getSpecification().getType() == 273) {
                    s.append(name + ": " + obj);
                    s.append("\n");
                    continue;
                }
                if (ignoreObjects.contains(obj)) {
                    s.append(name + ": " + obj + "*\n");
                    continue;
                }
                s.append(name + ": " + obj);
                Dump.graph(obj, level + 1, ignoreObjects, s);
            }
        }
        catch (RuntimeException e) {
            s.appendException(e);
        }
    }

    public static String specification(Naked object) {
        DebugString s = new DebugString();
        Dump.specification(object, s);
        return s.toString();
    }

    public static void specification(Naked naked, DebugString debug) {
        NakedObjectSpecification specification = naked.getSpecification();
        Dump.specification(specification, debug);
    }

    public static void specification(NakedObjectSpecification specification, DebugString debug) {
        try {
            debug.appendTitle(specification.getClass().getName());
            debug.appendln("Full Name", specification.getFullName());
            debug.appendln("Short Name", specification.getShortName());
            debug.appendln("Singular Name", specification.getSingularName());
            debug.appendln("Plural Name", specification.getPluralName());
            debug.appendln("Description", specification.getDescription());
            debug.blankLine();
            debug.appendln("Features", Dump.featureList(specification));
            debug.appendln("Type", Dump.typeNameFor(specification));
            if (specification instanceof NakedCollectionSpecification) {
                debug.appendln("Elements", ((NakedCollectionSpecification)specification).getElementType());
            }
            if (specification.superclass() != null) {
                debug.appendln("Superclass", specification.superclass().getFullName());
            }
            debug.appendln("Interfaces", Dump.specificationNames(specification.interfaces()));
            debug.appendln("Subclasses", Dump.specificationNames(specification.subclasses()));
        }
        catch (RuntimeException e) {
            debug.appendException(e);
        }
        if (specification instanceof DebugInfo) {
            ((DebugInfo)specification).debugData(debug);
        }
        debug.blankLine();
        debug.appendln("Fields");
        debug.indent();
        Dump.specificationFields(specification, debug);
        debug.unindent();
        debug.appendln("Object Actions");
        debug.indent();
        Dump.specificationActionMethods(specification, debug);
        debug.unindent();
        debug.appendln("Related Service Actions");
        debug.indent();
        Dump.specificationServiceMethods(specification, debug);
        debug.unindent();
    }

    public static String featureList(NakedObjectSpecification specification) {
        StringBuffer str = new StringBuffer();
        if (Features.isAbstract((NakedObjectSpecification)specification)) {
            str.append("Abstract ");
        }
        if (Features.isAggregated((NakedObjectSpecification)specification)) {
            str.append("Aggregated ");
        }
        if (Features.isBoundedSet((NakedObjectSpecification)specification)) {
            str.append("Bounded ");
        }
        if (Features.isCached((NakedObjectSpecification)specification)) {
            str.append("Cached ");
        }
        if (Features.isAlwaysImmutable((NakedObjectSpecification)specification)) {
            str.append("Immutable (always) ");
        }
        if (Features.isImmutableOncePersisted((NakedObjectSpecification)specification)) {
            str.append("Immutable (once persisted) ");
        }
        if (Features.isService((NakedObjectSpecification)specification)) {
            str.append("Service ");
        }
        return str.toString();
    }

    public static String typeNameFor(NakedObjectSpecification specification) {
        int type = specification.getType();
        switch (type) {
            case 275: {
                return "Collection";
            }
            case 276: {
                return "Map";
            }
            case 274: {
                return "Object";
            }
            case 272: {
                return "Primitive";
            }
            case 273: {
                return "Value";
            }
        }
        return "Unknown!";
    }

    private static void specificationActionMethods(NakedObjectSpecification specification, DebugString debug) {
        try {
            NakedObjectAction[] userActions = specification.getObjectActions(NakedObjectAction.USER);
            NakedObjectAction[] explActions = specification.getObjectActions(NakedObjectAction.EXPLORATION);
            NakedObjectAction[] debActions = specification.getObjectActions(NakedObjectAction.DEBUG);
            Dump.specificationMethods(userActions, explActions, debActions, debug);
        }
        catch (RuntimeException e) {
            debug.appendException(e);
        }
    }

    private static void specificationServiceMethods(NakedObjectSpecification specification, DebugString debug) {
        try {
            NakedObjectAction[] userActions = specification.getClassActions(NakedObjectAction.USER);
            NakedObjectAction[] explActions = specification.getClassActions(NakedObjectAction.EXPLORATION);
            NakedObjectAction[] debActions = specification.getClassActions(NakedObjectAction.DEBUG);
            Dump.specificationMethods(userActions, explActions, debActions, debug);
        }
        catch (RuntimeException e) {
            debug.appendException(e);
        }
    }

    private static void specificationFields(NakedObjectSpecification specification, DebugString debug) {
        try {
            NakedObjectField[] fields = specification.getFields();
            if (fields.length == 0) {
                debug.appendln("none");
            } else {
                for (int i = 0; i < fields.length; ++i) {
                    String help;
                    NakedObjectField f = fields[i];
                    debug.appendln(i + 1 + "." + f.getId() + "  (" + f.getClass().getName() + ")");
                    debug.indent();
                    String description = f.getDescription();
                    if (description != null && !description.equals("")) {
                        debug.appendln("Description", description);
                    }
                    if ((help = f.getHelp()) != null && !help.equals("")) {
                        debug.appendln("Help", help.substring(0, Math.min(30, help.length())) + (help.length() > 30 ? "..." : ""));
                    }
                    if (f.isValue()) {
                        int typicalLength;
                        int maximumLength = ((ValueAssociation)f).getMaximumLength();
                        if (maximumLength > 0) {
                            debug.appendln("Max length", maximumLength);
                        }
                        if ((typicalLength = ((ValueAssociation)f).getTypicalLineLength()) > 0) {
                            debug.appendln("Typical length", typicalLength);
                        }
                    }
                    debug.appendln("ID", f.getId());
                    debug.appendln("Name", f.getName());
                    debug.appendln("Type", (f.isCollection() ? "Collection" : (f.isObject() ? "Object" : (f.isValue() ? "Value" : "Unknown"))) + " (" + f.getSpecification().getFullName() + ")");
                    debug.appendln("Spec", Dump.typeNameFor(f.getSpecification()) + " (" + f.getSpecification() + ")");
                    debug.appendln("Flags", (f.isVisible() ? "Visible " : "") + (f.isPersisted() ? " " : "Not Persisted") + (f.isMandatory() ? "Mandatory " : ""));
                    Class[] extensions = f.getExtensions();
                    if (extensions.length > 0) {
                        debug.appendln("Extensions");
                        debug.indent();
                        boolean none = true;
                        for (int j = 0; j < extensions.length; ++j) {
                            debug.appendln(f.getExtension(extensions[j]).toString());
                            none = false;
                        }
                        if (none) {
                            debug.appendln("none");
                        }
                        debug.unindent();
                    }
                    debug.unindent();
                    debug.unindent();
                    debug.appendln(f.debugData());
                    debug.indent();
                }
            }
        }
        catch (RuntimeException e) {
            debug.appendException(e);
        }
    }

    private static void specificationMethods(NakedObjectAction[] userActions, NakedObjectAction[] explActions, NakedObjectAction[] debActions, DebugString debug) {
        if (userActions.length == 0 && explActions.length == 0 && debActions.length == 0) {
            debug.appendln("no actions...");
        } else {
            int i;
            debug.appendln("User actions");
            debug.indent();
            for (i = 0; i < userActions.length; ++i) {
                Dump.actionDetails(debug, userActions[i], 8, i);
            }
            debug.unindent();
            debug.appendln("Exploration actions");
            debug.indent();
            for (i = 0; i < explActions.length; ++i) {
                Dump.actionDetails(debug, explActions[i], 8, i);
            }
            debug.unindent();
            debug.appendln("Debug actions");
            debug.indent();
            for (i = 0; i < debActions.length; ++i) {
                Dump.actionDetails(debug, debActions[i], 8, i);
            }
            debug.unindent();
        }
    }

    private static void actionDetails(DebugString debug, NakedObjectAction a, int indent, int count) {
        debug.appendln(count + 1 + "." + a.getId() + " (" + a.getClass().getName() + ")");
        debug.indent();
        int newIndent = indent + 4;
        try {
            NakedObjectAction[] debActions = a.getActions();
            if (debActions.length > 0) {
                for (int i = 0; i < debActions.length; ++i) {
                    Dump.actionDetails(debug, debActions[i], newIndent, i);
                }
            } else {
                if (a.getDescription() != null && !a.getDescription().equals("")) {
                    debug.appendln("Description", a.getDescription());
                }
                debug.appendln("ID", a.getId());
                NakedObjectSpecification[] parameters = a.getParameterTypes();
                if (parameters.length == 0) {
                    debug.appendln("Parameters", "none");
                } else {
                    debug.appendln("Parameters");
                }
                debug.indent();
                for (int j = 0; j < parameters.length; ++j) {
                    debug.appendln(parameters[j].getFullName());
                }
                debug.unindent();
                debug.appendln("Target", a.getTarget());
                debug.appendln("On type", a.getOnType());
                debug.appendln("Returns", a.getReturnType());
                Class[] extensions = a.getExtensions();
                if (extensions.length > 0) {
                    debug.appendln("Extensions");
                    for (int j = 0; j < extensions.length; ++j) {
                        debug.appendln(extensions[j].getName());
                    }
                }
                debug.unindent();
                debug.unindent();
                debug.unindent();
                debug.append(a.debugData());
                debug.indent();
            }
        }
        catch (RuntimeException e) {
            debug.appendException(e);
        }
    }

    private static String[] specificationNames(NakedObjectSpecification[] specifications) {
        String[] names = new String[specifications.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = specifications[i].getFullName();
        }
        return names;
    }
}

