/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.util;

import java.text.NumberFormat;
import java.util.Hashtable;
import org.nakedobjects.nof.core.util.ProfilerSystem;

public class Profiler {
    private static final String DELIMITER = "\t";
    private static NumberFormat floatFormat = NumberFormat.getNumberInstance();
    private static NumberFormat integerFormat = NumberFormat.getNumberInstance();
    private static int nextId = 0;
    private static int nextThread = 0;
    protected static ProfilerSystem profilerSystem = new ProfilerSystem();
    private static Hashtable threads = new Hashtable();
    private long elapsedTime = 0L;
    private final int id;
    private long memory;
    private final String name;
    private long start = 0L;
    private final String thread;
    private boolean timing = false;

    public static String memoryLog() {
        long free = Profiler.memory();
        return integerFormat.format(free) + " bytes";
    }

    private static long memory() {
        return profilerSystem.memory();
    }

    private static long time() {
        return profilerSystem.time();
    }

    public static void setProfilerSystem(ProfilerSystem profilerSystem) {
        Profiler.profilerSystem = profilerSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler(String name) {
        this.name = name;
        Class<Profiler> clazz = Profiler.class;
        synchronized (Profiler.class) {
            this.id = nextId++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Thread t = Thread.currentThread();
            String thread = (String)threads.get(t);
            if (thread != null) {
                this.thread = thread;
            } else {
                this.thread = "t" + nextThread++;
                threads.put(t, this.thread);
            }
            this.memory = Profiler.memory();
            return;
        }
    }

    public long getElapsedTime() {
        return this.timing ? Profiler.time() - this.start : this.elapsedTime;
    }

    public long getMemoryUsage() {
        return Profiler.memory() - this.memory;
    }

    public String getName() {
        return this.name;
    }

    public String log() {
        return this.id + DELIMITER + this.thread + DELIMITER + this.getName() + DELIMITER + this.getMemoryUsage() + DELIMITER + this.getElapsedTime();
    }

    public void reset() {
        this.elapsedTime = 0L;
        this.start = Profiler.time();
        this.memory = Profiler.memory();
    }

    public void start() {
        this.start = Profiler.time();
        this.timing = true;
    }

    public void stop() {
        this.timing = false;
        long end = Profiler.time();
        this.elapsedTime += end - this.start;
    }

    public String memoryUsageLog() {
        return integerFormat.format(this.getMemoryUsage()) + " bytes";
    }

    public String timeLog() {
        return floatFormat.format((double)this.getElapsedTime() / 1000.0) + " secs";
    }

    public String toString() {
        return this.getElapsedTime() + "ms - " + this.name;
    }
}

