package org.nakedobjects.nof.core.adapter;

import java.util.Date;

import org.nakedobjects.noa.adapter.Version;


public abstract class AbstractVersion implements Version {
    protected String user;
    protected Date time;

    public AbstractVersion(final String user, final Date time) {
        this.user = user;
        this.time = time;
    }

    public Date getTime() {
        return time;
    }

    public String getUser() {
        return user;
    }

    public Version next(final String user, final Date time) {
        AbstractVersion newVersion = next();
        newVersion.user = user;
        newVersion.time = time;
        return newVersion;
    }

    protected abstract AbstractVersion next();

}
// Copyright (c) Naked Objects Group Ltd.
