package org.nakedobjects.nof.core.adapter;

import java.util.Enumeration;
import java.util.Vector;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.ToString;


public class InstanceCollectionVector extends AbstractNakedReference implements NakedCollection {
    private String name;
    private Vector instances;
    private NakedObjectSpecification instanceSpecification;

    public InstanceCollectionVector(final NakedObjectSpecification elementSpecification, final NakedObject[] instances) {
        this.instanceSpecification = elementSpecification;
        name = elementSpecification.getPluralName();

        int size = instances.length;
        this.instances = new Vector(size);
        for (int i = 0; i < size; i++) {
            this.instances.addElement(instances[i]);
        }
    }

    public InstanceCollectionVector(final NakedObjectSpecification elementSpecification, final Vector instances) {
        this.instanceSpecification = elementSpecification;
        name = elementSpecification.getPluralName();
        int size = instances.size();
        this.instances = new Vector(size);
        for (int i = 0; i < size; i++) {
            this.instances.addElement(instances.elementAt(i));
        }
    }

    public boolean contains(final NakedObject object) {
        return false;
    }

    public Enumeration elements() {
        return instances.elements();
    }


    public NakedObject firstElement() {
        if (size() == 0) {
            return null;
        } else {
            NakedObject element = (NakedObject) instances.elementAt(0);
            return element;
        }
    }

    public NakedObjectSpecification getElementSpecification() {
        return instanceSpecification;
    }

    public String getIconName() {
        return null;
    }

    public Object getObject() {
        return instances;
    }

    public void init(final Object[] initElements) {
        Assert.assertEquals("Collection not empty", 0, this.instances.size());
        for (int i = 0; i < initElements.length; i++) {
            instances.addElement(initElements[i]);
        }
    }
    
   public Persistable persistable() {
        return Persistable.TRANSIENT;
    }

    public void setOid(final Oid oid) {}

    public int size() {
        return instances.size();
    }

    public String titleString() {
        // return getElementSpecification().getPluralName() + "(" + size() + ")";
        return name + ", " + size();
    }

    public String toString() {
        ToString s = new ToString(this);
        toString(s);
        s.append("elements", instanceSpecification.getFullName());

        // title
        String title;
        try {
            title = "'" + this.titleString() + "'";
        } catch (NullPointerException e) {
            title = "none";
        }
        s.append("title", title);

        s.append("vector", instances);

        return s.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
