package org.nakedobjects.nof.core.adapter.map;

import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;


public class PojoAdapterHashMap implements PojoAdapterMap {
    private static final Logger LOG = Logger.getLogger(PojoAdapterHashMap.class);
    protected final Hashtable pojos;

    public PojoAdapterHashMap() {
        // TODO revert to 1000
        this(10);
    }

    public PojoAdapterHashMap(final int capacity) {
        pojos = new Hashtable(capacity);
    }

    public void add(final Object pojo, final Naked adapter) {
        LOG.debug("add " + new ToString(pojo) + " as " + adapter);
        pojos.put(pojo, adapter);
    }

    public boolean containsPojo(final Object pojo) {
        return pojos.containsKey(pojo);
    }

    public Enumeration elements() {
        return pojos.elements();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info("finalizing hash of pojos");
    }

    public void debugData(final DebugString debug) {
        Enumeration e = pojos.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            Object pojo = (Object) e.nextElement();
            NakedReference object = (NakedReference) pojos.get(pojo);
            debug.append(count++ + 1, 5);
            debug.append(" '");
            debug.append(pojo.toString(), 25);
            debug.append("'    ");
            debug.appendln(object.toString());
        }
    }

    public String debugTitle() {
        return "POJO Adapter Hashtable";
    }

    public Naked getPojo(final Object pojo) {
        return (Naked) pojos.get(pojo);
    }

    public void reset() {
        LOG.debug("reset");
        pojos.clear();
    }

    public void shutdown() {
        LOG.debug("shutdown");
        pojos.clear();
    }

    public void remove(final Naked object) {
        LOG.debug("remove " + object);
        pojos.remove(object.getObject());
    }
}
// Copyright (c) Naked Objects Group Ltd.
