package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.value.DateValue;
import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;


public abstract class AbstractDateAdapter extends AbstractTemporalValueAdapter  implements DateValue {
    
    private static Hashtable formats = new Hashtable();
    
    static {
        formats.put("iso", createDateFormat("yyyy-MM-dd"));
        formats.put(ISO_ENCODING_FORMAT, createDateFormat("yyyyMMdd"));
        formats.put("long", DateFormat.getDateInstance(DateFormat.LONG));
        formats.put("medium", DateFormat.getDateInstance(DateFormat.MEDIUM));
        formats.put("short", DateFormat.getDateInstance(DateFormat.SHORT));
    }

    public AbstractDateAdapter() {
        super("date");
        
        String formatRequired = NakedObjectsContext.getConfiguration().getString(Configuration.ROOT + "value.format.date");
        if (formatRequired == null) {
            format = (DateFormat) formats().get(defaultFormat());
        } else {
            setMask(formatRequired);
        }
    }

    protected void clearFields(Calendar cal) {
        cal.set(Calendar.HOUR, 0);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.AM_PM, 0);
        cal.set(Calendar.MILLISECOND, 0);
    }

    protected String defaultFormat() {
        return "medium";
    }

    public int defaultTypicalLength() {
        return 12;
    }

    public String getIconName() {
        return "date";
    }

    protected boolean ignoreTimeZone() {
        return true;
    }
    
    protected Hashtable formats() {
        return formats;
    }
}
// Copyright (c) Naked Objects Group Ltd.
