package org.nakedobjects.nof.core.adapter.value;

import java.text.DateFormat;
import java.util.Hashtable;

import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public abstract class AbstractDateTimeAdapter extends AbstractTemporalValueAdapter {
    private static Hashtable formats = new Hashtable();
    
    static {
        formats.put("iso", createDateFormat("yyyy-MM-dd HH:mm"));
        formats.put("iso_short", createDateFormat("yyyyMMdd'T'HHmm"));
        formats.put("iso_sec", createDateFormat("yyyy-MM-dd HH:mm:ss"));
        formats.put("iso_sec_short", createDateFormat("yyyyMMdd'T'HHmmss"));
        formats.put("iso_milli", createDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        formats.put("iso_milli_short", createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put(ISO_ENCODING_FORMAT, createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("long", DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG));
        formats.put("medium", DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.SHORT));
        formats.put("short", DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT));
    }

    public AbstractDateTimeAdapter() {
        super("datetime");
        
        String formatRequired = NakedObjectsContext.getConfiguration().getString(Configuration.ROOT + "value.format.datetime");
        if (formatRequired == null) {
            format = (DateFormat) formats().get(defaultFormat());
        } else {
            setMask(formatRequired);
        }
    }

    protected String defaultFormat() {
        return "medium";
    }

    public int defaultTypicalLength() {
        return 18;
    }

    protected Hashtable formats() {
        return formats;
    }

   public String getIconName() {
        return "time";
    }
}
// Copyright (c) Naked Objects Group Ltd.
