package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.value.TimeValue;
import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;


public abstract class AbstractTimeAdapter extends AbstractTemporalValueAdapter implements TimeValue {
    
    
    
    protected static void initFormats(final Hashtable formats) {
        formats.put("iso", createDateFormat("HH:mm"));
        formats.put("iso_sec", createDateFormat("HH:mm:ss"));
        formats.put("iso_milli", createDateFormat("HH:mm:ss.SSS"));
        formats.put( ISO_ENCODING_FORMAT, createDateFormat("HHmmssSSS"));
        formats.put("long", DateFormat.getTimeInstance(DateFormat.LONG));
        formats.put("medium", DateFormat.getTimeInstance(DateFormat.MEDIUM));
        formats.put("short", DateFormat.getTimeInstance(DateFormat.SHORT));
    }
    
    protected void clearFields(Calendar cal) {
        cal.set(Calendar.YEAR, 0);
        cal.set(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 0);
    }

   public AbstractTimeAdapter() {
        super("time");
        
        String formatRequired = NakedObjectsContext.getConfiguration().getString(Configuration.ROOT + "value.format.time");
        if (formatRequired == null) {
            format = (DateFormat) formats().get(defaultFormat());
        } else {
            setMask(formatRequired);
        }
    }

    protected String defaultFormat() {
        return "short";
    }
    
    public int defaultTypicalLength() {
        return 6;
    }

    public String getIconName() {
        return "time";
    }
}
// Copyright (c) Naked Objects Group Ltd.
