package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.FieldRegEx;
import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Assert;


public abstract class AbstractValueAdapter implements NakedValue {
    private NakedObjectSpecification specification;

    public boolean canClear() {
        return true;
    }

    public int defaultTypicalLength() {
        return 0;
    }

    /**
     * There is no default maximum length for this value (returns 0).
     */
    public int getMaximumLength() {
        return 0;
    }

    /**
     * The default minimum length is zero characters.
     */
    public int getMinumumLength() {
        return 0;
    }

    public NakedObjectSpecification getSpecification() {
        if (specification == null) {
            specification = NakedObjectsContext.getReflector().loadSpecification(getValueClass());
        }
        return specification;
    }


    public abstract Class getValueClass();
    
    public void parseTextEntry(final String entry) {
        if (entry == null) {
            throw new IllegalArgumentException("An entry must be provided");
        } else if (entry.trim().equals("") && canClear()) {
                clear();
        } else if (entry.trim().equals("") && mustHaveEntry()) {
            throw new InvalidEntryException("An entry is required");
        } else {
            doParse(entry);
        }
    }
        
    protected boolean mustHaveEntry() {
        return false;
    }

    protected abstract void doParse(String entry);

    public String asEncodedString() {
        return isEmpty() ? "NULL" : doEncode();
    }

    protected abstract String doEncode();

    public void restoreFromEncodedString(final String data) {
        Assert.assertNotNull(data);
        if ("NULL".equals(data)) {
            clear();
        } else {
            doRestore(data);
        }
    }
    
    protected abstract void doRestore(String data);

    public void setRegEx(final FieldRegEx regaEx) {}
    
    /////// toString ///////

    public abstract String toString();

}
// Copyright (c) Naked Objects Group Ltd.
