package org.nakedobjects.nof.core.adapter.value;

import java.sql.Date;
import java.util.Calendar;

import org.nakedobjects.applib.clock.Clock;

/**
 * An adapter that handles {@link java.sql.Date} with only date component.
 * 
 * @see DateTimeAdapter
 * @see TimeAdapter
 */
public class DateAdapter extends AbstractDateAdapter {
    private Date date;
    
    public DateAdapter() {
    }

    public DateAdapter(final Date date) {
        this();
        this.date = date;
    }

    protected void add(int years, int months, int days, int hours, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(Calendar.HOUR, 0);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.AM_PM, 0);
        cal.set(Calendar.MILLISECOND, 0);

        cal.add(Calendar.YEAR, years);
        cal.add(Calendar.MONTH, months);
        cal.add(Calendar.DAY_OF_MONTH, days);
        
        setDate(cal.getTime());
    }
    
    public java.util.Date dateValue() {
        return date == null ? null : new java.util.Date(date.getTime());
    }

    public void clear() {
        date = null;
    }

    public boolean isEmpty() {
        return date == null;
    }
    
    public Object getObject() {
        return date;
    }

    public Class getValueClass() {
        return Date.class;
    }

    protected void setDate(java.util.Date date) {
        setValue(date);
    }
    
    public void setValue(java.util.Date date) {
        this.date = new Date(date.getTime());
    }

    protected void now() {
        date = new Date(Clock.getTime());
    }
    
    public void setValue(final Date date) {
        this.date = new Date(date.getTime());
    }

    public String toString() {
        return "DateAdapter: " + date;
    }

}
// Copyright (c) Naked Objects Group Ltd.
