package org.nakedobjects.nof.core.adapter.value;

import java.util.Calendar;
import java.util.Date;

import org.nakedobjects.applib.clock.Clock;


/**
 * An adapter that handles {@link java.util.Date} as both a date AND time component.
 * 
 * @see DateAdapter
 * @see TimeAdapter
 */
public class DateTimeAdapter extends AbstractDateTimeAdapter {
    private java.util.Date date;

    public DateTimeAdapter() {
    }

    public DateTimeAdapter(final Date date) {
        this();
        this.date = date;
    }

    public void clear() {
        date = null;
    }

    public boolean isEmpty() {
        return date == null;
    }

    public Date dateValue() {
        return date == null ? null : new Date(date.getTime());
    }

    public Object getObject() {
        return date;
    }

    public Class getValueClass() {
        return Date.class;
    }

    public void setValue(final Date date) {
        this.date = new Date(date.getTime());
    }

    public String toString() {
        return "DateTimeAdapter: " + date;
    }

    protected void add(int years, int months, int days, int hours, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        cal.add(Calendar.YEAR, years);
        cal.add(Calendar.MONTH, months);
        cal.add(Calendar.DAY_OF_MONTH, days);
        cal.add(Calendar.HOUR, hours);
        cal.add(Calendar.MINUTE, minutes);
        
        setDate(cal.getTime());
    }
    
    protected void now() {
        this.date = new Date(Clock.getTime());
    }

    protected void setDate(Date date) {
        this.date = date;
    }
}
// Copyright (c) Naked Objects Group Ltd.
