package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.LongValue;
import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public class LongAdapter extends AbstractValueAdapter implements LongValue {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format = DEFAULT_FORMAT;
    private Long value;

    public LongAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString(Configuration.ROOT + "value.format.long");
        if (formatRequired == null) {
            format = DEFAULT_FORMAT;
        } else {
            setMask(formatRequired);
        }
    }

    public LongAdapter(final Long value) {
        this();
        this.value = value;
    }

    // ///// titleString, icon, valueClass ///////

    public String titleString() {
        return value == null ? "" : format.format(value);
    }

    public String getIconName() {
        return "long";
    }

    public Class getValueClass() {
        return Long.class;
    }

    // ///// Accessor ///////

    public Long longValue() {
        return value;
    }

    public Object getObject() {
        return value;
    }

    // ///// Null Handling ///////

    public boolean canClear() {
        return true;
    }

    public void clear() {
        value = null;
    }

    public boolean isEmpty() {
        return value == null;
    }

    // ///// Mutator ///////

    public void setValue(final Long value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            value = new Long(format.parse(entry).longValue());
        } catch (ParseException e) {
            throw new TextEntryParseException("Not a whole number " + entry, e);
        }
    }

    // ///// Encode, Decode ///////

    protected String doEncode() {
        return value.toString();
    }

    protected void doRestore(String data) {
        value = new Long(data);
    }

    // ///// Semantics ///////

    public void setMask(String mask) {
        format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 18;
    }

    // // ///// toString ///////
    public String toString() {
        return "LongAdapter: " + value;
    }

}
// Copyright (c) Naked Objects Group Ltd.
