package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.FieldRegEx;
import org.nakedobjects.noa.adapter.InvalidEntryException;


/**
 * Abstract class for do regular expression validations and string formatting. This class needs to be extended
 * in a platform specific way.
 */
public abstract class RegExProcessor {
    private static RegExProcessor instance;

    public static String formatEntry(FieldRegEx regEx, String entry) {
        return instance.format(regEx, entry);
    }

    public static void validateEntry(FieldRegEx regEx, String entry) {
        if (!isEntryValid(regEx, entry)) {
            throw new InvalidEntryException("Entry does not match pattern");
        }
    }

    public static boolean isEntryValid(FieldRegEx regEx, String entry) {
        return instance.isValid(regEx, entry);
    }

    protected RegExProcessor() {
        instance = this;
    }

    protected abstract String format(FieldRegEx regEx, String text);

    protected abstract boolean isValid(FieldRegEx regEx, String text);

}

// Copyright (c) Naked Objects Group Ltd.
