package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.applib.clock.Clock;
import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;



/**
 * Treats {@link java.sql.Time} as a time-only value type.
 * 
 */
public class TimeAdapter extends AbstractTimeAdapter {
    private static Hashtable formats = new Hashtable();
    
    static {
        initFormats(formats);
    }
    
    private java.sql.Time time;

    public TimeAdapter() {
    }
    
    public TimeAdapter(final java.sql.Time time) {
        this();
        this.time = time;
    }
 
    protected void add(int years, int months, int days, int hours, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(Calendar.YEAR, 0);
        cal.set(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 0);
        cal.set(Calendar.MILLISECOND, 0);

        cal.add(Calendar.HOUR, hours);
        cal.add(Calendar.MINUTE, minutes);

        setDate(cal.getTime());
    }
    
    public void clear() {
        time = null;
    }

    public java.util.Date dateValue() {
        return time == null ? null : new java.util.Date(time.getTime());
    }

    protected Hashtable formats() {
        return formats;
    }

    public Object getObject() {
        return time;
    }

    public Class getValueClass() {
        return java.sql.Date.class;
    }

    public boolean isEmpty() {
        return time == null;
    }
    
    protected void now() {
        time = new java.sql.Time(Clock.getTime());
    }
    
    protected void setDate(Date date) {
        time = new java.sql.Time(date.getTime());
    }
    
    public void setValue(Date date) {
        time = new java.sql.Time(date.getTime());
    }
    
    public void setValue(final java.sql.Time time) {
        setValue(time);
    }

    public Date timeValue() {
        return time;
    }

    public String toString() {
        return "TimeOnlyAdapter: " + time;
    }
    
}
// Copyright (c) Naked Objects Group Ltd.
