package org.nakedobjects.nof.core.client;

import org.nakedobjects.noa.client.NakedObjectClient;
import org.nakedobjects.noa.security.SessionManager;
import org.nakedobjects.noa.security.AuthenticationRequest;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.noa.security.ConnectionManager;
import org.nakedobjects.nof.core.security.ExplorationSession;


public abstract class AbstractClient implements NakedObjectClient {
    protected boolean authenticateUser;
    protected ConnectionManager connectionManager;
    protected SessionManager sessionManager;
    protected String title;
    private boolean inExplorationMode;
    private AuthenticationRequest authenticationRequestViaArgs;

    public void setAuthenticationRequestViaArgs(AuthenticationRequest authenticationRequest) {
        this.authenticationRequestViaArgs = authenticationRequest;
    }

    protected abstract AuthenticationRequest promptForAuthenticationDetails();

    protected boolean login() {
        Session session;
        if (authenticateUser) {
            do {
                AuthenticationRequest request = this.authenticationRequestViaArgs;
                if (request == null) {
                    request = promptForAuthenticationDetails();
                }
                if (request == null) {
                    return false;
                }
                session = sessionManager.authenticate(request);
  /*
                if (session == null) {
                    // any provided authenticationRequestViaArgs must have been invalid,
                    // so reset. This will cause us to prompt the next time.
                    this.authenticationRequestViaArgs = null;
                }
*/
                this.authenticationRequestViaArgs = null;
            } while (session == null);
        } else {
            session = new ExplorationSession();
        }
        connectionManager.connect(session);
        return true;
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_Exploration(final boolean inExplorationMode) {
        setExploration(inExplorationMode);
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_Title(final String title) {
        this.title = title;
    }

    public void setAuthenticate(boolean authenticateUser) {
        this.authenticateUser = authenticateUser;
    }

    public void setExploration(final boolean inExplorationMode) {
        this.inExplorationMode = inExplorationMode;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }
    
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected boolean showExplorationMethods() {
        return inExplorationMode;
    }

    public void shutdown() {
        connectionManager.shutdown();
        System.exit(0);
    }
}

// Copyright (c) Naked Objects Group Ltd.
