package org.nakedobjects.nof.core.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.nakedobjects.noa.NakedObjectRuntimeException;


/**
 * Superset of the functionality provided by {@link PropertiesFileReader}, 
 * in that multiple property files can be loaded.
 */
public class PropertiesFilesReader implements ConfigurationReader {
    private Properties properties;
    private boolean ensureFileLoads;

    public PropertiesFilesReader(final boolean ensureFileLoads) {
        properties = new Properties();
        this.ensureFileLoads = ensureFileLoads;
    }

    public PropertiesFilesReader(final String pathname, final boolean ensureFileLoads) {
        this(ensureFileLoads);
        loadProperties(pathname);
    }

    /**
     * Loads properties from supplied path; if there is a clash with properties
     * overridden, then they will be overridden.
     * 
     * @param pathname
     */
    public void loadProperties(String pathname) {
        try {
            FileInputStream in;
            File file = new File(pathname);
            in = new FileInputStream(file);
            properties.load(in);
        } catch (FileNotFoundException e) {
            if (ensureFileLoads) {
                throw new NakedObjectRuntimeException("Could not find required configuration file: " + pathname);
            }
        } catch (IOException e) {
            throw new NakedObjectRuntimeException("Could not load configuration file: " + pathname, e);
        }
    }

    public Properties getProperties() {
        return properties;
    }
}
// Copyright (c) Naked Objects Group Ltd.
