package org.nakedobjects.nof.core.context;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.object.MessageBroker;


public abstract class MultiUserContext extends NakedObjectsContext {

    protected MultiUserContext() {}

    protected String executionContextId() {
        return getLocal().executionContextId();
    }

    protected abstract NakedObjectsData getLocal();

    protected MessageBroker messageBroker() {
        return getLocal().messageBroker;
    }

    protected NakedObjectLoader objectLoader() {
        return getLocal().objectLoader;
    }

    protected NakedObjectPersistor objectPersistor() {
        return getLocal().objectPersistor;
    }

    protected Session session() {
        return getLocal().session;
    }
    
    protected UpdateNotifier updateNotifier() {
        return getLocal().updateNotifier;
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_ObjectLoader(final NakedObjectLoader objectLoader) {
        setObjectLoader(objectLoader);
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_ObjectPersistor(final NakedObjectPersistor objectManager) {
        setObjectPersistor(objectManager);
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_SpecificationLoader(final NakedObjectReflector specificationLoader) {
        setReflector(specificationLoader);
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_TemplateImageLoader(TemplateImageLoader loader) {
        this.setTemplateImageLoader(loader);
    }

    public void setObjectLoader(final NakedObjectLoader objectLoader) {
        getLocal().objectLoader = objectLoader;
    }

    public void setObjectPersistor(final NakedObjectPersistor objectManager) {
        getLocal().objectPersistor = objectManager;
    }

    public void setSession(final Session session) {
        if (getLocal().session != null) {
            throw new NakedObjectRuntimeException("Session already exists on this thread");
        }
        getLocal().session = session;
        getLocal().accessTime = System.currentTimeMillis();
    }
    
    public void clearSession() {
        getLocal().takeSnapshot();
        getLocal().session = null;
        getLocal().messageBroker.ensureEmpty();
        getLocal().updateNotifier.ensureEmpty();
    }

    public void setReflector(final NakedObjectReflector specificationLoader) {
        getLocal().reflector = specificationLoader;
    }

    public void setTemplateImageLoader(TemplateImageLoader loader) {
        getLocal().templateImageLoader = loader;
    }

    protected NakedObjectReflector reflector() {
        return getLocal().reflector;
    }

    protected TemplateImageLoader templateImageLoader() {
        return getLocal().templateImageLoader;
    }
}
// Copyright (c) Naked Objects Group Ltd.
