package org.nakedobjects.nof.core.context;

import org.nakedobjects.noa.adapter.NakedObject;

import java.util.ArrayList;
import java.util.List;


public class Perspective {
    private String name;
    private final List objects = new ArrayList();
    private final List services = new ArrayList();
    private String userName;

    public void addToObjects(final Object object) {
        if (!objects.contains(object)) {
            objects.add(object);
            objectChanged();
        }
    }

    private void objectChanged() {
      /*  NakedObject adapter;
        adapter = NakedObjectsContext.getObjectLoader().getAdapterFor(this);
        if (adapter != null) {
            NakedObjectsContext.getObjectPersistor().objectChanged(adapter);
        } */
    }

    public void addToServices(final Object service) {
        if (!services.contains(service)) {
            services.add(service);
            objectChanged();
        }
    }

    public String getName() {
        return name;
    }

    public List getObjects() {
        return objects;
    }

    public List getServices() {
        return services;
    }

    public String getUserName() {
        return userName;
    }

    public void removeFromObjects(final Object object) {
        objects.add(object);
        objectChanged();
    }

    public void removeFromServices(final Object service) {
        services.remove(service);
        objectChanged();
    }

    public void setName(final String name) {
        this.name = name;
        objectChanged();
    }

    /* this is needed by hibernate to work */
    void setObjects(List objects) {}

    /* this is needed by hibernate to work */
    void setServices(List services) {}

    public void setUserName(String userName) {
        this.userName = userName;
        objectChanged();
    }

    public String title() {
        return name + " (" + getUserName() + ", " + services.size() + " classes)";
    }
}
// Copyright (c) Naked Objects Group Ltd.
