package org.nakedobjects.nof.core.context;

import java.util.Enumeration;
import java.util.Vector;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.object.MessageBroker;


public class SimpleMessageBroker implements MessageBroker, DebugInfo {
    private Vector messages = new Vector();
    private Vector warnings = new Vector();

    public String[] getMessages() {
        return convert(messages);
    }

    private String[] convert(final Vector items) {
        String[] m = new String[items.size()];
        int i = 0;
        for (Enumeration e = items.elements(); e.hasMoreElements();) {
            m[i++] = e.nextElement().toString();
        }
        items.removeAllElements();
        return m;
    }

    public void debugData(DebugString debug) {
        debugArray(debug, "Messages", messages);
        debugArray(debug, "Warnings", messages);
    }

    private void debugArray(DebugString debug, String title, Vector vector) {
        debug.appendln(title);
        debug.indent();
        if (vector.size() == 0) {
            debug.appendln("none");
        } else {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String text = (String) enumeration.nextElement();
                debug.appendln(text);
            }
        }
        debug.unindent();
    }

    public String debugTitle() {
        return "Simple Message Broker";
    }

    public void ensureEmpty() {
        if (warnings.size() > 0) {
            throw new NakedObjectRuntimeException("Message broker still has warnings");
        }
        if (messages.size() > 0) {
            throw new NakedObjectRuntimeException("Message broker still has messages");
        }
    }
    
    public String[] getWarnings() {
        return convert(warnings);
    }

    public void addWarning(final String message) {
        warnings.addElement(message);
    }

    public void addMessage(final String message) {
        messages.addElement(message);
    }

}
// Copyright (c) Naked Objects Group Ltd.
