package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.UnexpectedCallException;


/**
 * Generates OIDs based on the system clock.
 */
public class SimpleOidGenerator implements OidGenerator {
    private long persistentSerialNumber;
    private long transientSerialNumber;
    private final long start;

    public SimpleOidGenerator() {
        this(0);
    }

    public SimpleOidGenerator(final long start) {
        this.start = start;

        // see init
        persistentSerialNumber = start;
        transientSerialNumber = -start; // TODO this is simple, but not reliable, fix to try to ensure that ids on
                                        // server and clients don't overlap.
    }

    public void debugData(final DebugString debug) {
        debug.appendln("Start", start);
        debug.appendln("Persistent", persistentSerialNumber);
        debug.appendln("Transient", transientSerialNumber);
    }

    public String debugTitle() {
        return name();
    }

    public void init() {
//        persistentSerialNumber = start;
//        transientSerialNumber = -start; // TODO this is simple, but not reliable, fix to try to ensure that ids on
                                        // server and clients don't overlap.
    }

    public String name() {
        return "Simple Serial OID Generator";
    }

    public void shutdown() {}

    public void convertPersistentToTransientOid(final Oid oid) {
        throw new UnexpectedCallException();
    }

    public synchronized void convertTransientToPersistentOid(final Oid oid) {
        Assert.assertTrue(oid instanceof SerialOid);
        SerialOid serialOid = (SerialOid) oid;
        serialOid.makePersistent(persistentSerialNumber++);
    }

    public synchronized Oid createTransientOid(Object object) {
        return SerialOid.createTransient(transientSerialNumber++);
    }
}
// Copyright (c) Naked Objects Group Ltd.
