package org.nakedobjects.nof.core.security;

import org.nakedobjects.noa.NakedObjectRuntimeException;


/**
 * Indicates that there is no Authenticator available to authenticate a user based on this request.
 */
public class NoAuthenticatorException extends NakedObjectRuntimeException {
    private static final long serialVersionUID = 1L;

    public NoAuthenticatorException() {}

    public NoAuthenticatorException(String msg) {
        super(msg);
    }

    public NoAuthenticatorException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public NoAuthenticatorException(Throwable cause) {
        super(cause);
    }

}

// Copyright (c) Naked Objects Group Ltd.
