package org.nakedobjects.nof.core.service;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.ToString;


public final class SimpleRepository {
    public static String[] parameterNamesFindByTitle() {
        return new String[] { "Title to find" };
    }

    public static boolean[] parametersRequiredFindByTitle() {
        return new boolean[] { true };
    }

    private final Class cls;
    private NakedObjectSpecification spec;
    private boolean includeSubclasses;

    public SimpleRepository(Class cls) {
        this.cls = cls;
    }

    public Object[] allInstances() {
        return RepositoryHelper.allInstances(getSpec(), cls, includeSubclasses);
    }

    public String disableAllInstances() {
        return hasInstances() ? null : "No " + getSpec().getPluralName();
    }

    public String disableFindByTitle() {
        return disableAllInstances();
    }

    public Object[] findByTitle(final String title) {
        return RepositoryHelper.findByTitle(getSpec(), cls, includeSubclasses, title).toArray();
    }

    public String getId() {
        return "repository#" + getClass().getName();
    }

    private boolean hasInstances() {
        return RepositoryHelper.hasInstances(getSpec(), includeSubclasses);
    }

    public String iconName() {
        return getSpec().getShortName();
    }

    public Object newPersistentInstance() {
        NakedObject adapter = NakedObjectsContext.getObjectLoader().createTransientInstance(getSpec());
        NakedObjectsContext.getObjectPersistor().makePersistent(adapter);
        return adapter.getObject();
    }

    public Object newTransientInstance() {
        return NakedObjectsContext.getObjectLoader().createTransientInstance(getSpec()).getObject();
    }

    public String title() {
        return getSpec().getPluralName();
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("class", cls.getName());
        return str.toString();
    }

    public static boolean alwaysHideSpec() {
        return true;
    }
    
    protected NakedObjectSpecification getSpec() {
        if (spec == null) {
            spec = NakedObjectsContext.getReflector().loadSpecification(cls);
            includeSubclasses = Features.isAbstract(spec);
        }
        return spec;
    }
}

// Copyright (c) Naked Objects Group Ltd.
