package org.nakedobjects.nof.core.undo;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public class SetValueCommand implements Command {
    private final String description;
    private final OneToOneAssociation value;
    private NakedObject object;
    private String oldValue;

    public SetValueCommand(final NakedObject object, final OneToOneAssociation value) {
        NakedValue fld = (NakedValue) value.get(object);
        this.oldValue = fld.asEncodedString();
        this.object = object;
        this.value = value;

        this.description = "reset the value to " + oldValue;
    }

    public String getDescription() {
        return description;
    }

    public void undo() {
        NakedValue fld = (NakedValue) value.get(object);
        fld.restoreFromEncodedString(oldValue);
        NakedObjectsContext.getObjectPersistor().saveChanges();
    }

    public void execute() {}

    public String getName() {
        return "entry";
    }
}
// Copyright (c) Naked Objects Group Ltd.
