package org.nakedobjects.nof.core.undo;

import java.util.Vector;


public class UndoStack {
    private Vector commands = new Vector();

    public void add(final Command command) {
        commands.addElement(command);
        command.execute();
    }

    public void undoLastCommand() {
        Command lastCommand = (Command) commands.lastElement();
        lastCommand.undo();
        commands.removeElement(lastCommand);
    }

    public String descriptionOfUndo() {
        Command lastCommand = (Command) commands.lastElement();
        return lastCommand.getDescription();
    }

    public boolean isEmpty() {
        return commands.isEmpty();
    }

    public String getNameOfUndo() {
        Command lastCommand = (Command) commands.lastElement();
        return lastCommand.getName();
    }
}
// Copyright (c) Naked Objects Group Ltd.
