package org.nakedobjects.nof.core.util;

import java.io.OutputStream;

import org.nakedobjects.noa.util.ByteEncoderBuffer;


public class DebugByteEncoder extends ByteEncoderBuffer {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(DebugByteEncoder.class);

    public DebugByteEncoder(final OutputStream encoder) {
        super(encoder);
    }

    public void add(boolean flag) {
        LOG.debug("boolean: " + flag);
        super.add(flag);
    }

    public void add(byte[] value) {
        LOG.debug("bytes: (" + value.length + ") " + new String(value));
        super.add(value);
    }

    public void add(byte value) {
        LOG.debug("byte: " + value);
        super.add(value);
    }

    public void add(int value) {
        LOG.debug("int: " + value);
        super.add(value);
    }

    public void add(long value) {
        LOG.debug("long: " + value);
        super.add(value);
    }

    public void add(Object object) {
        LOG.debug(">>> object: (" + object + ")");
        super.add(object);
    }

    public void add(Object[] objects) {
        LOG.debug(">>> objects x" + objects.length);
        super.add(objects);
    }

    public void add(String entry) {
        LOG.debug("string: " + entry);
        super.add(entry);
    }

    public void add(String[] list) {
        StringBuffer l = new StringBuffer();
        for (int i = 0; i < list.length; i++) {
            if(i > 0) {
                l.append(", ");
            }
            l.append(list[i]);
        }
        LOG.debug("list: " + l);
        super.add(list);
    }
    
    public void end() {
        LOG.debug("<<<  end");
        super.end();
    }
}

// Copyright (c) Naked Objects Group Ltd.
