package org.nakedobjects.nof.core.util;

import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Properties;


public class DefaultNakedObjectConfiguration implements NakedObjectConfiguration {

    /**
     * This is a <i>copy</i> of the config passed into the
     * {@link #DefaultNakedObjectConfiguration(NakedObjectConfiguration) constructor}.
     */
    protected NakedObjectConfiguration underlying;

    public DefaultNakedObjectConfiguration(NakedObjectConfiguration original) {
        underlying = original.getProperties("");
    }

    /**
     * Adds a set of properties to the underlying configuration, with the specified prefix.
     * 
     * @param prefix
     * @param properties
     */
    public void addProperties(String prefix, Properties properties) {
        Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String) e.nextElement();
            String value = properties.getProperty(propertyName);
            add(prefix + "." + propertyName, value);
        }
    }

    public void add(String name, String value) {
        underlying.add(name, value);
    }

    public NakedObjectConfiguration createSubset(String prefix) {
        return underlying.createSubset(prefix);
    }

    public boolean getBoolean(String name) {
        return underlying.getBoolean(name);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return underlying.getBoolean(name, defaultValue);
    }

    public Color getColor(String name) {
        return underlying.getColor(name);
    }

    public Color getColor(String name, Color defaultValue) {
        return underlying.getColor(name, defaultValue);
    }

    public Font getFont(String name) {
        return underlying.getFont(name);
    }

    public Font getFont(String name, Font defaultValue) {
        return underlying.getFont(name, defaultValue);
    }

    public int getInteger(String name) {
        return underlying.getInteger(name);
    }

    public int getInteger(String name, int defaultValue) {
        return underlying.getInteger(name, defaultValue);
    }

    public String[] getList(String name) {
        return underlying.getList(name);
    }

    public NakedObjectConfiguration getProperties(String withPrefix) {
        return underlying.getProperties(withPrefix);
    }

    public String getString(String name) {
        return underlying.getString(name);
    }

    public String getString(String name, String defaultValue) {
        return underlying.getString(name, defaultValue);
    }

    public boolean hasProperty(String name) {
        return underlying.hasProperty(name);
    }

    public boolean isEmpty() {
        return underlying.isEmpty();
    }

    public Enumeration propertyNames() {
        return underlying.propertyNames();
    }

    public String rootPath() {
        return underlying.rootPath();
    }
    
    public int size() {
        return underlying.size();
    }

    public void debugData(DebugString debug) {
        underlying.debugData(debug);
    }

    public String debugTitle() {
        return underlying.debugTitle();
    }

}
