package org.nakedobjects.nof.core.adapter.value;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.testing.TestSystem;


public abstract class AbstractValueAdapterTestCase extends TestCase {
    protected NakedValue value;
    
    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        new TestSystem().init();
    }

    public void testIsEmpty() throws Exception {
        assertFalse(value.isEmpty());
    }

    public void testClear() throws Exception {
        value.clear();
        assertTrue(value.isEmpty());
    }
    
    public void testCanClear() throws Exception {
        assertEquals(true, value.canClear());
    }

    public void testParseNull() throws Exception {
        try {
            value.parseTextEntry(null);
            fail();
        } catch (IllegalArgumentException expected) {}
    }

    public void testParseEmptyString() throws Exception {
        value.parseTextEntry("");
        assertTrue(value.isEmpty());
    }

    public void testDecodeNULL() throws Exception {
        value.restoreFromEncodedString("NULL");
        assertTrue(value.isEmpty());
    }
    
    public void testToStringDoesNotFail() throws Exception {
        value.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
