package org.nakedobjects.nof.core.adapter.value;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.testing.TestSystem;


public abstract class AbstractValueAdapterWithNullTestCase extends TestCase {
    protected NakedValue value;
    
    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        new TestSystem().init();
    }

    public void testIsEmpty() throws Exception {
        assertTrue(value.isEmpty());
    }

    public void testTitle() throws Exception {
        assertEquals("", value.titleString());
    }

    public void testEncode() throws Exception {
        assertEquals("NULL", value.asEncodedString());
    }
    
    public void testToStringDoesntFail() throws Exception {
        value.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
