package org.nakedobjects.nof.core.adapter.value;

import java.math.BigDecimal;

import org.nakedobjects.noa.adapter.TextEntryParseException;


public class BigDecimalAdapterTest extends AbstractValueAdapterTestCase {

    private BigDecimalAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        super.value = value = new BigDecimalAdapter(new BigDecimal("132.199"));
    }

    public void testParseValidString() throws Exception {
        value.parseTextEntry("2142342334");
        assertEquals(new BigDecimal(2142342334L), value.bigDecimalValue());
    }

    public void testParseInvalidString() throws Exception {
        try {
            value.parseTextEntry("214xxx2342334");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testTitle() throws Exception {
        assertEquals("132.199", value.titleString());    
    }
    
    public void testEncode() throws Exception {
        assertEquals("132.199", value.asEncodedString());
    }
    
    public void testDecode() throws Exception {
        value.restoreFromEncodedString("4322.89991");
        assertEquals(new BigDecimal("4322.89991"), value.bigDecimalValue());
    }

}

// Copyright (c) Naked Objects Group Ltd.
