package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.nof.core.adapter.value.CharAdapter;


public class CharacterAdapterTest extends AbstractValueAdapterTestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(CharacterAdapterTest.class);
    }

    private CharAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        super.value = value = new CharAdapter(new Character('r'));
    }

    public void testIntegerValue() {
        assertEquals('r', value.charValue().charValue());
    }

    public void testPClear() throws Exception {
        value.clear();
        assertTrue(value.isEmpty());
    }

    public void testParseLongString() throws Exception {
        try {
            value.parseTextEntry("one");
            fail();
        } catch (InvalidEntryException expected) {}
    }

    public void testLengths() {
        assertEquals(0, value.getMaximumLength());
        assertEquals(0, value.getMinumumLength());
    }

    public void testOutputAsString() {
        assertEquals("r", value.titleString());
    }

    public void testValidParse() throws Exception {
        value.parseTextEntry("t");
        assertEquals(new Character('t'), value.charValue());
    }
    
    public void testEncode() throws Exception {
        assertEquals("r", value.asEncodedString());
    }
    
    public void testDecode() throws Exception {
        value.restoreFromEncodedString("Y");
        assertEquals('Y', value.charValue().charValue());
    }
}
// Copyright (c) Naked Objects Group Ltd.
