package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;


public class FloatAdapterTest extends AbstractValueAdapterTestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(FloatAdapterTest.class);
    }

    private FloatAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        super.value = value = new FloatAdapter(new Float(32.5f));
    }

    public void testFloatValue() {
        assertEquals(32.5, value.floatValue().floatValue(), 0.0);
    }

    public void testInvalidParse() throws Exception {
        try {
            value.parseTextEntry("one");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testLengths() {
        assertEquals(0, value.getMaximumLength());
        assertEquals(0, value.getMinumumLength());
    }

    public void testOutputAsString() {
        assertEquals("32.5", value.titleString());

        value.setValue(Float.valueOf(35000000.0f));
        assertEquals("35,000,000", value.titleString());
    }

    public void testParse() throws Exception {
        value.parseTextEntry("120.50");
        assertEquals(120.5f, value.floatValue().floatValue(), 0.0);

        value.parseTextEntry("1,20.0");
        assertEquals(120f, value.floatValue().floatValue(), 0.0);
    }

    public void testIsNotEmpty() throws Exception {
        assertFalse(value.isEmpty());
    }

    public void testEncode() throws Exception {
        assertEquals("32.5", value.asEncodedString());
    }

    public void testDescode() throws Exception {
        value.restoreFromEncodedString("10.25");
        assertEquals(10.25, value.floatValue().floatValue(), 0.0);
    }
    
}
// Copyright (c) Naked Objects Group Ltd.
