package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.testing.TestSystem;


public class IntAdapterTest extends AbstractValueAdapterTestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(IntAdapterTest.class);
    }

    private IntAdapter value;

    protected void setUp() throws Exception {
        new TestSystem().init();
        super.value = value = new IntAdapter(new Integer(32));
    }

    public void testIntegerValue() {
        assertEquals(32, value.integerValue().intValue());
    }

    public void testInvalidParse() throws Exception {
        try {
            value.parseTextEntry("one");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testLengths() {
        assertEquals(0, value.getMaximumLength());
        assertEquals(0, value.getMinumumLength());
    }

    public void testTitleString() {
        assertEquals("32", value.titleString());

        value.setValue(Integer.valueOf(1032));
        assertEquals("1,032", value.titleString());
    }

    public void testParse() throws Exception {
        value.parseTextEntry("120");
        assertEquals(120, value.integerValue().intValue());

        value.parseTextEntry("1,20.0");
        assertEquals(120, value.integerValue().intValue());
    }
}
// Copyright (c) Naked Objects Group Ltd.
