package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.testing.TestSystem;


public class ShortAdapterTest extends AbstractValueAdapterTestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(ShortAdapterTest.class);
    }

    private ShortAdapter value;

    protected void setUp() throws Exception {
        new TestSystem().init();
        super.value = value = new ShortAdapter(new Short((short) 32));
    }

    public void testShortValue() {
        assertEquals(32, value.shortValue().shortValue());

        value.setValue(Short.valueOf((short)-102));
        assertEquals(-102, value.shortValue().shortValue());
    }

    public void testInvalidParse() throws Exception {
        try {
            value.parseTextEntry("one");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testLengths() {
        assertEquals(0, value.getMaximumLength());
        assertEquals(0, value.getMinumumLength());
    }

    public void testOutputAsString() {
        assertEquals("32", value.titleString());

        value.setValue(Short.valueOf((short)-128));
        assertEquals("-128", value.titleString());
    }

    public void testParse() throws Exception {
        value.parseTextEntry("120");
        assertEquals(120, value.shortValue().shortValue());

        value.parseTextEntry("1,20.0");
        assertEquals(120, value.shortValue().shortValue());
    }

}
// Copyright (c) Naked Objects Group Ltd.
