package org.nakedobjects.nof.core.conf;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;

public class DefaultConfigurationLoaderTest extends TestCase {
    DefaultConfigurationLoader loader;
    
    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        loader = new DefaultConfigurationLoader("src/test/config");
    }
    
    public void testDefaultConfiguration() {
        NakedObjectConfiguration configuration = loader.load();
        assertEquals("one", configuration.getString("properties.example"));
    }

    public void testAddConfiguration() {
        loader.addConfigurationFile("another.properties", true);
        NakedObjectConfiguration configuration = loader.load();
        assertEquals("added", configuration.getString("additional.example"));
    }

    public void testAddedConfigurationOveridesEarlierProperties() {
        loader.addConfigurationFile("another.properties", true);
        NakedObjectConfiguration configuration = loader.load();
        assertEquals("two", configuration.getString("properties.example"));
    }
    
    public void testAddedConfigurationFailsWhenFileNotFound() {
        try {
            loader.addConfigurationFile("unfound.properties", true);
            fail();
        } catch (NakedObjectRuntimeException expected) {        }
    }
    
    public void testAddedConfigurationIgnoreUnfoundFile() {
        loader.addConfigurationFile("unfound.properties", false);
    }
    
    public void testAddProperty() throws Exception {
        loader.add("added.property", "added by code");
        NakedObjectConfiguration configuration = loader.load();
        assertEquals("added by code", configuration.getString("added.property"));
    }
    
    public void testIncludeSystemProperty() throws Exception {
        loader.setIncludeSystemProperties(true);
        NakedObjectConfiguration configuration = loader.load();
        assertEquals(System.getProperty("os.name"), configuration.getString("os.name"));
    }
    
    public void testAddConfigurationInDifferentDirectory() throws Exception {
        loader.addConfigurationFile("src/test", "three.properties", true);
        NakedObjectConfiguration configuration = loader.load();
        assertEquals("version 3", configuration.getString("different.property"));
    }
}


// Copyright (c) Naked Objects Group Ltd.
