package org.nakedobjects.nof.testsystem;

import java.util.Hashtable;
import java.util.Vector;

import junit.framework.Assert;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.persist.UnsupportedFindException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.OidGenerator;
import org.nakedobjects.nof.core.util.NotImplementedException;

import test.org.nakedobjects.object.MockNakedObject;


public class TestProxyPersistor implements NakedObjectPersistor {

    public static TestProxyPersistor setup() {
        TestProxyPersistor persistor;
        persistor = new TestProxyPersistor();
        persistor.reset();
        return persistor;
    }

    private Vector actions = new Vector();
    private Hashtable objects = new Hashtable();
    private OidGenerator generator;

    public TestProxyPersistor() {
        generator = new TestProxyOidGenerator();
        
    }

    public void abortTransaction() {}

    public void assertAction(final int i, final String action) {
        if (i >= actions.size()) {
            Assert.fail("No such action " + action);
        }
        Assert.assertEquals(action, actions.elementAt(i));
    }

    protected void createClass(final NakedObjectSpecification nc) throws ObjectPersistenceException {}

    public void destroyObject(final NakedObject object) {
        actions.addElement("object deleted " + object.getOid());

    }

    public void endTransaction() {
        actions.addElement("end transaction");
    }

    protected NakedObject[] getInstances(final InstancesCriteria criteria) {
        return null;
    }

    public NakedObject[] getInstances(final NakedObjectSpecification cls, final boolean includeSubclasses) {
        return new NakedObject[] { new MockNakedObject(), new MockNakedObject(), };
    }

    public NakedObject getObject(final Oid oid, final NakedObjectSpecification hint) {
        if (NakedObjectsContext.getObjectLoader().isIdentityKnown(oid)) {
            return NakedObjectsContext.getObjectLoader().getAdapterFor(oid);
        } else {
            NakedObject nakedObject = (NakedObject) objects.get(oid);
            if (nakedObject == null) {
                throw new TestProxyException("No persisted object to get for " + oid);
            }
            return nakedObject;
        }
    }

    public Oid getOidForService(String name) {
        return null;
    }

    public boolean hasInstances(final NakedObjectSpecification cls, final boolean includeSubclasses) {
        throw new NotImplementedException();
    }

    public boolean isInitialized() {
        return true;
    }

    public void init() {}

    public void makePersistent(final NakedObject object) {
        object.setOptimisticLock(new TestProxyVersion(1));
        object.changeState(ResolveState.RESOLVED);
        objects.put(object.getOid(), object);
    }

    public void objectChanged(final NakedObject object) {
        actions.addElement("object changed " + object.getOid());

        object.setOptimisticLock(((TestProxyVersion) object.getVersion()).next());
    }

    public void reload(final NakedObject object) {}

    public void reset() {
        actions.removeAllElements();
    }

    public void resolveField(final NakedObject object, final NakedObjectField field) {}

    public void resolveImmediately(final NakedObject object) {}

    public void saveChanges() {}

    public void setupAddObject(final NakedObject object) {
        objects.put(object.getOid(), object);
    }

    public void setServices(Object[] services) {}
    
    public void shutdown() {}

    public void startTransaction() {
        actions.addElement("start transaction");
    }

    public boolean flushTransaction() {
        actions.addElement("flush transaction");
        return false;
    }

    public Oid createTransientOid(Object object) {
        return generator.createTransientOid(object);
    }

    public void convertTransientToPersistentOid(Oid oid) {
        generator.convertTransientToPersistentOid(oid);
    }

    public void convertPersistentToTransientOid(Oid oid) {
        generator.convertPersistentToTransientOid(oid);
    }

    public NakedCollection findInstances(InstancesCriteria criteria) throws UnsupportedFindException {
        throw new NotImplementedException();

    }
}
// Copyright (c) Naked Objects Group Ltd.
